#ifndef ExRootFactory_h
#define ExRootFactory_h

/** \class ExRootFactory
 *
 *  Class handling creation of ExRootCandidate,
 *  ExRootCandList and all other objects.
 *
 *  $Date: 2008-06-04 13:57:25 $
 *  $Revision: 1.1 $
 *
 *
 *  \author P. Demin - UCL, Louvain-la-Neuve
 *
 */

#include "TNamed.h"

#include <map>
#include <set>

class TObjArray;

class ExRootTreeBranch;
class ExRootTreeWriter;

class ExRootCandList;
class ExRootCandidate;

class ExRootFactory: public TNamed
{
public:
  
  ExRootFactory();
  ~ExRootFactory();

  void Clear();

  TObjArray *NewArray();

  TObjArray *NewPermanentArray();

  ExRootCandList *NewCandList();
  ExRootCandidate *NewCandidate();

  ExRootCandList *NewPermanentCandList();
  ExRootCandidate *NewPermanentCandidate();

  TObject *New(TClass *cl);

  template<typename T>
  T *New() { return static_cast<T *>(New(T::Class())); }


private:

  ExRootTreeWriter *fTreeWriter; //!

  ExRootTreeBranch *fPermanentObjArrays; //!

  ExRootTreeBranch *fPermanentCandLists; //!

  ExRootTreeBranch *fPermanentCandidates; //!

  std::map<const TClass *, ExRootTreeBranch *> fMakers; //!
  std::set<TObject *> fPool; //!

  ClassDef(ExRootFactory, 1)
};

#endif /* ExRootFactory */

