#ifndef MadGraphJetLeptonMerger_h
#define MadGraphJetLeptonMerger_h

#include "ExRootAnalysis/ExRootModule.h"

class TObjArray;
class TIterator;

class MadGraphJetLeptonMerger: public ExRootModule
{
public:

  MadGraphJetLeptonMerger();
  ~MadGraphJetLeptonMerger();

  void Init();
  void Process();
  void Finish();

private:

  const TObjArray *fInputLeptons; //!
  const TObjArray *fInputJets; //!

  TIterator *fItInputLeptons; //!
  TIterator *fItInputJets; //!

  TObjArray *fOutputArray; //!
  
  Int_t fJetNumberMax;

  ClassDef(MadGraphJetLeptonMerger, 1)
};

#endif
